import { connect } from 'react-redux';
import loader from 'hoc/loader';
import * as a from 'modules/phone/redux/history/actions';
import { getCallState } from 'modules/phone/redux/history/selectors';

import CallCardPreview from './CallCardPreview';

const mapState = (state, props) => ({
  call: (getCallState(state, props.id) || {}).data,
});

const mapDispatch = (dispatch, props) => ({
  onMount: () => dispatch(a.fetch(props.id)),
  onUnmount: () => dispatch(a.destroy(props.id)),
});

export default connect(mapState, mapDispatch)(loader()(CallCardPreview));
