import { getFormValues } from 'redux-form';
import { connect } from 'react-redux';
import { ETypeString, EObject } from 'types/entities';
import { createPageLink, AppModuleString } from 'modules/requestForm2';
import Link from '@crm/components/dist/lego2/react-router/Link';
import { getAccount, getNewCallId } from 'modules/phone/selectors';
import { CALL_MAIL_NAME } from 'modules/phone/constants';
import css from './RequestLinkFromNewCall.module.css';

interface FormData {
  to?: string;
}

const mapState = (state) => {
  const account = getAccount(state) || {};
  const { id: accountId, campaignId } = account;
  const callId = getNewCallId(state);

  let eObj: EObject | undefined;
  // callId can be 0 from backend
  if (callId != null) {
    eObj = {
      eid: callId,
      etype: ETypeString.SpCall,
    };
  }

  const formValues: FormData | undefined = getFormValues(CALL_MAIL_NAME)(state);

  let email;
  if (formValues && formValues.to) {
    email = formValues.to;
  }

  // todo: разнести на компоненты
  return {
    target: '_blank',
    children: 'Заявка',
    className: css.b,
    to: createPageLink({
      data: {
        email,
        accountId,
        campaignId,
        byEObject: eObj,
      },
      context: { module: AppModuleString.Telephony, action: 'SpCall' },
    }),
  };
};

export default connect(mapState)(Link);
