/*
eslint-disable
react/style-prop-object,
jsx-a11y/anchor-is-valid,
jsx-a11y/click-events-have-key-events,
jsx-a11y/no-static-element-interactions,
*/

import React from 'react';
import PropTypes from 'prop-types';
import backendTypes from 'constants/backendTypes';
import IconCallPersonal from 'components/Icons/IconCallPersonal';
import LinkModule from 'components/LinkModule';
import ItemDate from 'modules/clientHistory/components/HistoryItems/ItemDate';
import ItemColumnDate from 'modules/clientHistory/components/HistoryItems/ItemColumnDate';
import ItemColumn from 'modules/clientHistory/components/HistoryItems/ItemColumn';
import ItemWrap from 'modules/clientHistory/components/HistoryItems/ItemWrap';
import ItemHeader from 'modules/clientHistory/components/HistoryItems/ItemHeader';
import ItemBadge from 'modules/clientHistory/components/HistoryItems/ItemBadge';
import ItemIcon from 'modules/clientHistory/components/HistoryItems/ItemIcon';
import Name from 'components/Name';
import PlainText from 'components/PlainText';
import CallIcon from '../CallIcon';
import { CALL_TYPES } from '../../constants';
import Call from '../CallCard/CallHistoryContainer';
import css from './CallHistoryItem.modules.scss';

const DIRECTION_ICON = {
  In: CALL_TYPES.INSIDE,
  Out: CALL_TYPES.OUTSIDE,
};

const CallHistory = ({
  data: { hasFactors, comment, id, date, author, scope, subject, direction },
  toggle,
  onToggle,
  item,
}) => (
  <ItemWrap isOpen={toggle}>
    <div className={css.CallHistoryItem__headerWrap} onClick={onToggle}>
      <ItemHeader>
        <ItemIcon
          type="Call"
          supIcon={props => <CallIcon {...props} type={DIRECTION_ICON[direction]} />}
        >
          {scope === 'Personal' && <IconCallPersonal />}
        </ItemIcon>
        <ItemColumn
          title={
            <span>
              Звонок&nbsp;
              {hasFactors && <ItemBadge type="Upsale" />}
            </span>
          }
          subTitle={subject}
        />
        <ItemColumn title={author ? <Name name={author.name} /> : null} />
        <ItemColumnDate item={item}>
          <LinkModule type={backendTypes.CALL} id={id} isStopPropagation>
            <ItemDate date={date} />
          </LinkModule>
        </ItemColumnDate>
      </ItemHeader>
      {comment && <PlainText className={css.CallHistoryItem__comment} text={comment} link />}
    </div>
    {toggle && <Call id={id} />}
  </ItemWrap>
);

CallHistory.propTypes = {
  toggle: PropTypes.bool,
  onToggle: PropTypes.func.isRequired,
  item: PropTypes.instanceOf(Object),
  data: PropTypes.instanceOf(Object),
};

CallHistory.defaultProps = {
  toggle: false,
  item: undefined,
  data: {},
};

export default CallHistory;
