import { createElement } from 'react';
import PropTypes from 'prop-types';
import Icon from 'components/Icons/Icon';
import { CALL_TYPES } from '../constants';

const ICON_CONFIG = {
  [CALL_TYPES.MISSING]: {
    pack: Icon.PACKS.MATERIAL,
    icon: 'call_missed',
  },
  [CALL_TYPES.OUTSIDE]: {
    pack: Icon.PACKS.MATERIAL,
    icon: 'call_made',
  },
  [CALL_TYPES.INSIDE]: {
    pack: Icon.PACKS.MATERIAL,
    icon: 'call_received',
  },
};

const CallIcon = (props) => {
  const { type, ...passPropsThrough } = props;

  return createElement(Icon, { ...ICON_CONFIG[type], ...passPropsThrough });
};

CallIcon.propTypes = {
  type: PropTypes.string.isRequired,
};

export default CallIcon;
