import { createElement } from 'react';
import { connect } from 'react-redux';
import { call } from 'modules/phone/redux/actions/phone';
import frontendStatus from 'modules/phone/redux/frontendStatus';
import { getIsConnectionReady } from 'modules/phone/selectors';
import Link from '@crm/components/dist/lego2/Link';

const CallTo = (props) => {
  const { component, onClick, isAllowCall, ...passPropsThrough } = props;

  let renderComponent = component;
  let renderProps = null;
  if (!renderComponent) {
    renderComponent = Link;
    renderProps = { tabIndex: 0 };
    if (!isAllowCall) {
      renderProps.disabled = true;
    }
  }

  return createElement(renderComponent, { onClick, ...renderProps, ...passPropsThrough });
};

const mapState = (state) => ({
  isAllowCall:
    frontendStatus.selectors.status(state) !==
      frontendStatus.FRONTEND_MANAGER_STATUS.OUTBOUND_CALL && getIsConnectionReady(state),
});

const mapDispatch = (dispatch, { phone, cardData }) => ({
  onClick: (e) => {
    e.preventDefault();
    e.stopPropagation();
    dispatch(call(phone, cardData));
  },
});

export default connect(mapState, mapDispatch)(CallTo);
