import React from 'react';
import PropTypes from 'prop-types';
import HistoryItem from './HistoryItem';
import css from './History.modules.scss';

const History = (props) => {
  const { history } = props;

  if (!(Array.isArray(history) && history.length > 0)) {
    return null;
  }

  return (
    <div className={css.History}>
      <div className={css.History__title}>История звонка</div>
      <div className={css.History__body}>
        { history.map(comment => <HistoryItem data={comment} key={comment.id} />) }
      </div>
    </div>
  );
};

History.propTypes = {
  history: PropTypes.instanceOf(Array),
};

History.defaultProps = {
  history: undefined,
};

export default History;
