import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import PlainText from 'components/PlainText';
import StaffCard from 'components/StaffCard';
import cx from 'classnames';
import css from './History.modules.scss';

const HistoryItem = (props) => {
  const {
    data: {
      comment,
      author,
      date,
      phaseNum,
    },
    className,
  } = props;

  return (
    <div className={cx(css.HistoryItem, className)}>
      <div className={css.comment__header}>
        <span className={css.HistoryItem__phase}>{phaseNum}</span>
        <span className={css.comment__meta}>
          <StaffCard user={author} />&nbsp;
          <FormattedDate
            value={new Date(date)}
            year="numeric"
            month="numeric"
            day="numeric"
            hour="numeric"
            minute="numeric"
          />
        </span>
      </div>
      <PlainText text={comment} />
    </div>
  );
};

HistoryItem.propTypes = {
  data: PropTypes.shape({
    comment: PropTypes.string.isRequired,
    author: PropTypes.instanceOf(Object).isRequired,
    date: PropTypes.string.isRequired,
  }).isRequired,
  className: PropTypes.string,
};

HistoryItem.defaultProps = {
  className: undefined,
};

export default HistoryItem;
