import React from 'react';
import PropTypes from 'prop-types';
import Select from '@crm/components/dist/lego2/Select';

const Interface = (props) => {
  const { interface: pInterface, ...passPropsThrough } = props;

  return (
    <Select
      size="m"
      value={pInterface.value}
      hasEmptyValue={false}
      options={pInterface.list.map((key) => {
        const obj = pInterface.map[key];
        return {
          value: key,
          content: obj.interface,
        };
      })}
      {...passPropsThrough}
    />
  );
};

Interface.propTypes = {
  interface: PropTypes.instanceOf(Object).isRequired,
};

export default Interface;
