import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { getInterface } from 'modules/phone/selectors';
import { getInterfaceSettings, setInterfaceSettings } from 'modules/phone/redux/actions/phone';
import Interface from './Interface';
import withModuleInit from '../withModuleInit';

class InterfaceContainer extends React.Component {
  static propTypes = {
    getInterfaceSettings: PropTypes.func.isRequired,
    isLoad: PropTypes.bool.isRequired,
  }

  componentDidMount() {
    this.props.getInterfaceSettings();
  }

  render() {
    const { isLoad, ...passPropsThrough } = this.props;

    if (!isLoad) {
      return null;
    }

    return createElement(Interface, passPropsThrough);
  }
}

const mapState = (state) => {
  const interfaceData = getInterface(state);
  return {
    isLoad: !!interfaceData,
    interface: interfaceData,
  };
};

export default withModuleInit()((
  connect(
    mapState,
    { getInterfaceSettings, onChange: setInterfaceSettings },
  )(InterfaceContainer)
));
