import React from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import ModuleIcon from 'components/ModuleIcon';
import propTypes from '../../propTypes';
import { StatusIcon } from '../Status';

const PhoneModuleIcon = (props) => {
  const { status } = props;

  return (
    <ModuleIcon
      icon={(cls) => <Icon svg="phone" svgSize="l" className={cls} />}
      subIconTop={<StatusIcon status={status} />}
    />
  );
};

PhoneModuleIcon.propTypes = {
  status: propTypes.status,
};

PhoneModuleIcon.defaultProps = {
  status: undefined,
};

export default PhoneModuleIcon;
