import { Component, createElement } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { getIsConnectionReady } from '../selectors';

class ModuleInit extends Component {
  render() {
    const {
      isConnectionReady,
      component,
      children,
      ...passPropsThrough
    } = this.props;

    if (isConnectionReady) {
      if (component) {
        return createElement(component, passPropsThrough, children);
      }

      return children;
    }

    return null;
  }
}

ModuleInit.propTypes = {
  isConnectionReady: PropTypes.bool,
  children: PropTypes.node,
  component: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
};

ModuleInit.defaultProps = {
  isConnectionReady: false,
  children: undefined,
  component: undefined,
};

export default connect(state => ({
  isConnectionReady: getIsConnectionReady(state),
}))(ModuleInit);
