import React from 'react';
import PropTypes from 'prop-types';
import ClientHistoryLazilyLoad from 'modules/clientHistory/ClientHistoryLazilyLoad';
import { Account } from 'pages/accounts/modules/info';
import TitleChain from 'modules/heading';
import get from 'lodash/get';
import PhoneToolbar from '../PhoneToolbar';
import { CallCardPreview } from '../CallCard';
import css from './PageCall.modules.scss';

const LayoutCall = props => {
  const { call } = props;

  const accountId = get(call, 'account.id');

  return (
    <div className={css.LayoutCallWrap}>
      <TitleChain>Звонок</TitleChain>
      <PhoneToolbar />
      <div className={css.LayoutCall}>
        {accountId && (
          <div className={css.LayoutCall__account}>
            <Account id={accountId} isCompact mode={Account.MODES.TELEPHONY_READONLY} />
          </div>
        )}
        <CallCardPreview call={call} />
        {accountId && <ClientHistoryLazilyLoad accountId={accountId} />}
      </div>
    </div>
  );
};

LayoutCall.propTypes = {
  call: PropTypes.instanceOf(Object),
};

LayoutCall.defaultProps = {
  call: {},
};

export default LayoutCall;
