import { Component, createElement } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { getSaveCall } from 'modules/phone/selectors';
import * as actions from 'modules/phone/redux/actions/savedCall';
import PageCall from './PageCall';

class PageCallContainer extends Component {
  static propTypes = {
    destroy: PropTypes.func.isRequired,
    load: PropTypes.func.isRequired,
    call: PropTypes.instanceOf(Object),
  }

  static defaultProps = {
    call: undefined,
  }

  componentDidMount() {
    this.loadCall(this.props);
  }

  componentWillReceiveProps(nextProps) {
    this.loadCall(nextProps, this.props);
  }

  componentWillUnmount() {
    this.props.destroy();
  }

  loadCall(nextProps, props) {
    let nextCallId;
    let callId;
    let preloadId;

    try {
      nextCallId = Number.parseInt(nextProps.params.id, 10);
    } catch (e) { /* empty */ }

    try {
      callId = Number.parseInt(props.params.id, 10);
    } catch (e) { /* empty */ }

    try {
      ({ preloadId } = nextProps.location.state);
    } catch (e) { /* empty */ }

    if (nextCallId !== callId) {
      if (nextCallId) {
        if (nextCallId !== preloadId) {
          this.props.load(nextCallId);
        }
      } else {
        this.props.destroy();
      }
    }
  }

  render() {
    const passPropsThrough = { ...this.props };
    delete passPropsThrough.destroy;
    delete passPropsThrough.load;

    if (this.props.call) {
      return createElement(PageCall, passPropsThrough);
    }

    return null;
  }
}

export default connect((state) => {
  const call = getSaveCall(state);

  return {
    call,
  };
}, actions)(PageCallContainer);
