import React from 'react';
import PropTypes from 'prop-types';
import ClientSelectInputWithModal from 'modules/clientSelectInputWithModal';
import { Prompt } from 'react-router-dom';
import Metrika from 'modules/metrika';
import Tip from 'components/Tip';
import backendTypes from 'constants/backendTypes';
import { Account } from 'pages/accounts/modules/info';
import Empty from 'components/Empty';
import { BEFORE_UNLOAD_MESSAGE } from 'modules/phone/constants';
import TitleChain from 'modules/heading';
import PhoneToolbar from '../PhoneToolbar';
import CallBar from '../CallBar';
import CallCard from '../CallCard';
import Panel from '../Panel';
import css from './PageCallNew.modules.scss';

const right = () => <CallBar />;

const LayoutCall = (props) => {
  const {
    account,
    call,
    onSetAccount,
    disabledSetNewAccount,
    isPreventUnloud,
    isCreateAccount,
    canOpenPinForm,
    showPinForm,
  } = props;

  return (
    <div className={css.LayoutCallWrap}>
      <TitleChain>Новый звонок</TitleChain>
      <Metrika.Store module_name={backendTypes.CALL} item_id={call.callInfo && call.callInfo.id} />
      <Prompt when={isPreventUnloud} message={BEFORE_UNLOAD_MESSAGE} />
      <PhoneToolbar right={right}>
        <ClientSelectInputWithModal
          disabledSetNewAccount={disabledSetNewAccount}
          onChange={onSetAccount}
          autoFocus={!account}
          isCreateAccount={isCreateAccount}
          canCreateLead
          onPinButtonClick={canOpenPinForm ? showPinForm : undefined}
        />
      </PhoneToolbar>
      <div className={css.LayoutCall}>
        <div className={css.LayoutCall__account}>
          {call && call.tip && <Tip tip={call.tip} className={css.LayoutCall__tip} />}
          {account ? (
            <Account
              id={account.id}
              isCompact
              mode={Account.MODES.TELEPHONY}
              campaignId={account.campaignId}
            />
          ) : (
            <Empty icon="person" text="Аккаунт не выбран" />
          )}
        </div>
        <CallCard call={call} autoFocus={Boolean(account)} account={account} />

        <Panel account={account} />
      </div>
    </div>
  );
};

LayoutCall.propTypes = {
  account: PropTypes.instanceOf(Object),
  canOpenPinForm: PropTypes.bool.isRequired,
  disabledSetNewAccount: PropTypes.bool,
  isPreventUnloud: PropTypes.bool,
  isCreateAccount: PropTypes.bool,
  onSetAccount: PropTypes.func.isRequired,
  showPinForm: PropTypes.func.isRequired,
  call: PropTypes.instanceOf(Object),
};

LayoutCall.defaultProps = {
  account: undefined,
  disabledSetNewAccount: false,
  isPreventUnloud: false,
  isCreateAccount: false,
  call: undefined,
};

export default LayoutCall;
