import { Component, createElement } from 'react';
import PropTypes from 'prop-types';
import { NULL_CLIENT } from 'constants/index';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import {
  getAccount,
  getNewCall,
  getIsLoadNewCall,
  getIsSaveNewCall,
  getIsCreateAccountForNewCall,
  canOpenPinForm,
} from 'modules/phone/selectors';
import { BEFORE_UNLOAD_MESSAGE } from 'modules/phone/constants';
import { withBeforeUnload } from 'components/BeforeUnload';
import { load, destroy, setAccount, showPinForm } from 'modules/phone/redux/actions/newCall';
import PageCallNew from './PageCallNew';

const WithUnloadPageCallNew = withBeforeUnload({ message: BEFORE_UNLOAD_MESSAGE })(PageCallNew);

class LayoutCallContainer extends Component {
  static propTypes = {
    destroy: PropTypes.func.isRequired,
    load: PropTypes.func.isRequired,
    isCallLoad: PropTypes.bool,
    isSave: PropTypes.bool,
  };

  static defaultProps = {
    isCallLoad: false,
    isSave: false,
  };

  componentDidMount() {
    this.props.load();
  }

  componentWillUnmount() {
    this.props.destroy();
  }

  render() {
    const passPropsThrough = { ...this.props };
    delete passPropsThrough.destroy;
    delete passPropsThrough.load;
    delete passPropsThrough.isCallLoad;

    const { isSave } = this.props;

    if (!this.props.isCallLoad) {
      return null;
    }

    return createElement(WithUnloadPageCallNew, { ...passPropsThrough, isPreventUnloud: !isSave });
  }
}

const mapDispatch = dispatch => ({
  onSetAccount: account => dispatch(setAccount(account)),
  showPinForm: () => dispatch(showPinForm()),
  ...bindActionCreators({ destroy, load }, dispatch),
});

export default connect(state => {
  const account = getAccount(state);
  const call = getNewCall(state);
  const isCallLoad = getIsLoadNewCall(state);

  return {
    account,
    call,
    isCallLoad,
    canOpenPinForm: canOpenPinForm(state),
    disabledSetNewAccount: account && account.id === NULL_CLIENT.id,
    isSave: getIsSaveNewCall(state),
    isCreateAccount: getIsCreateAccountForNewCall(state),
  };
}, mapDispatch)(LayoutCallContainer);
