import React, { PureComponent } from 'react';
import { connect } from 'react-redux';
import { isTelephonyAccess } from 'modules/phone/selectors';
import { Link as LinkInside } from 'react-router-dom';
import { InfiniteTableView } from 'containers/InfiniteList';
import TitleChain from 'modules/heading';
import toLocalISOString from 'utils/date/toLocalISOString';
import PhoneToolbar from '../PhoneToolbar';
import { loadCalls } from '../../api';
import TableCall from './TableCall';
import css from './PageCalls.modules.scss';
import LogsFilter from '../PhoneToolbar/LogsFilter';

const TABLE_SETTINGS = {
  columnVisibility: {
    date: true,
    phoneNumber: true,
    account: true,
    comment: true,
  },
  grid: {
    columns: [
      { name: 'type', title: 'Тип' },
      { name: 'date', title: 'Дата' },
      { name: 'phoneNumber', title: 'Номер телефона' },
      { name: 'duration', title: 'Продолжительность' },
      { name: 'account', title: 'Аккаунт' },
      { name: 'comment', title: 'Комментарий' },
    ],
  },
  flexRatio: {
    comment: 2,
    default: 1,
  },
};

const createProvider = (extendsArgs = {}) => args => loadCalls({ ...args, ...extendsArgs });

class PageCalls extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      provider: createProvider(this.getInitTimeRange()),
    };
  }

  getInitTimeRange = (daysBefore = 30) => {
    const now = new Date();
    const toDate = toLocalISOString(now);
    now.setDate(now.getDate() - daysBefore);
    const fromDate = toLocalISOString(now);
    return { toDate, fromDate };
  };

  getRightForToolbar = () => (
    <LogsFilter defaultRange={this.getInitTimeRange()} changeProvider={this.changeProvider} />
  );

  getLeftForToolbar = () => (
    <LinkInside to="/phone/new" target="_blank">
      Новый звонок
    </LinkInside>
  );

  changeProvider = extendsArgs => {
    this.setState({ provider: createProvider(extendsArgs) });
  };

  render() {
    /**
     * TODO:
     * 1. завести тикет на рефаторинг этого компонента (декомпозиция  + ts)
     * 2. Описать типы и тем самым решить проблему ниже
     */
    // eslint-disable-next-line react/prop-types
    const { newCallLink } = this.props;

    return (
      <div className={css.PageCalls}>
        <TitleChain>Журнал звонков</TitleChain>
        <PhoneToolbar
          left={newCallLink ? this.getLeftForToolbar : undefined}
          right={this.getRightForToolbar}
        />
        <InfiniteTableView
          className={css.PageCalls__table}
          name="phone"
          onLoad={this.state.provider}
          rowComponent={TableCall}
          withNavigation={false}
          // TODO: При рендере таблицы пропсы прокидываются как атрибуты DOMNode со значением '[Object Object]'
          {...TABLE_SETTINGS}
          loadOnMount
          canSelect
          reloadOnLoadUpdate
        />
      </div>
    );
  }
}

export default connect(state => ({ newCallLink: isTelephonyAccess(state) }))(PageCalls);
