import { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import getCallGuid from 'modules/phone/utils/getCallGuid';
import browserWindow from 'utils/browserWindow';
import { initWebsocket } from 'modules/phone/redux/actions/phone';
import {
  LOCAL_STORAGE_OPEN_CALL_ID_KEY,
  BACKEND_AUTHORIZATION_NAME,
  LOCAL_STORAGE_PHONE_MAIN_TAB,
} from 'modules/phone/constants';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import { getActiveCall } from '../selectors';

class PhoneInit extends Component {
  constructor(props) {
    super(props);

    this.tabGuid = Math.round(Math.random() * 100000);
  }

  componentDidMount() {
    this.props.initWebsocket();
    this.openCall(this.props);
  }

  componentWillReceiveProps(nextProps) {
    this.openCall(nextProps);
  }

  openCall(nextProps) {
    const callId = getCallGuid(nextProps.activeCall);

    if (callId) {
      const lastCallId = localStorage.getItem(LOCAL_STORAGE_OPEN_CALL_ID_KEY);
      if (callId !== lastCallId) {
        localStorage.setItem(LOCAL_STORAGE_PHONE_MAIN_TAB, this.tabGuid);

        setTimeout(() => {
          const phoneMainTab = parseInt(localStorage.getItem(LOCAL_STORAGE_PHONE_MAIN_TAB), 10);
          if (phoneMainTab === this.tabGuid) {
            localStorage.setItem(LOCAL_STORAGE_OPEN_CALL_ID_KEY, callId);
            localStorage.setItem(LOCAL_STORAGE_PHONE_MAIN_TAB, '');
            browserWindow.open('/phone/new/');
          }
        }, 50);
      }
    }
  }

  render() {
    return null;
  }
}

PhoneInit.propTypes = {
  // eslint-disable-next-line react/no-unused-prop-types
  activeCall: PropTypes.instanceOf(Object),
  initWebsocket: PropTypes.func.isRequired,
};

PhoneInit.defaultProps = {
  activeCall: undefined,
};

export default moduleAuthorization(BACKEND_AUTHORIZATION_NAME, { errorComponent: null })(
  connect(
    state => ({
      activeCall: getActiveCall(state),
    }),
    { initWebsocket },
  )(PhoneInit),
);
