import React, { Component } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import DateTimePicker from 'lego/components/DateTimePicker';

import css from './LogsFilter.module.css';
import { LogsFilterProps, LogsFilterState } from './LogsFilter.types';

// TODO: есть необхождимость завернуть это в final-form
export default class LogsFilter extends Component<LogsFilterProps, LogsFilterState> {
  public constructor(props) {
    super(props);
    this.state = props.defaultRange;
  }

  private changeFromDate = (date: string) => {
    this.setState({ fromDate: date });
  };

  private changeToDate = (date: string) => {
    this.setState({ toDate: date });
  };

  private changeProvider = () => {
    const { changeProvider } = this.props;
    changeProvider({ ...this.state });
  };

  public render() {
    const { fromDate, toDate } = this.state;

    return (
      <div className={css['phone-logs-filter']}>
        <DateTimePicker size="s" value={fromDate} onChange={this.changeFromDate} />
        <DateTimePicker size="s" value={toDate} onChange={this.changeToDate} />
        <Button size="s" view="action" onClick={this.changeProvider}>
          Применить
        </Button>
      </div>
    );
  }
}
