import React, { PureComponent } from 'react';
import { Toolbar } from 'components/Layout';

import { MODULE_NAME } from '../../constants';
// eslint-disable-next-line import/no-named-as-default,import/no-named-as-default-member
import Status from '../Status';
import Reason from '../Reason';
import { PhoneToolbarProps } from './PhoneToolbar.types';

const style = {
  zIndex: 10,
};

export class PhoneToolbar extends PureComponent<PhoneToolbarProps> {
  public render() {
    const { children, left, right, reason } = this.props;

    return (
      <div style={style}>
        <Toolbar>
          <Toolbar.Left>
            <Toolbar.Title>
              <Toolbar.TitleName>{MODULE_NAME}</Toolbar.TitleName>
              <Status />
            </Toolbar.Title>
            {children}
            {typeof left === 'function' && left()}
          </Toolbar.Left>
          <Toolbar.Right>
            {typeof right === 'function' && right()}
            <Reason reason={reason} />
          </Toolbar.Right>
        </Toolbar>
      </div>
    );
  }
}
