import React from 'react';
import { connect } from 'react-redux';
import { isTelephonyAccess } from 'modules/phone/selectors';
import { Route, Switch } from 'react-router-dom';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import PageCalls from './PageCalls';
import PageCall from './PageCall';
import PageCallNew from './PageCallNew';
import ModuleInit from './ModuleInit';
import { BACKEND_AUTHORIZATION_NAME } from '../constants';

const AuthModuleInit = moduleAuthorization(BACKEND_AUTHORIZATION_NAME)(ModuleInit);

const PageCallAdapter = ({ match }) => <PageCall params={match.params} />;

const PhoneRouter = ({ match, isNewRoute }) => (
  <AuthModuleInit>
    <Switch>
      <Route exact path={match.url} component={PageCalls} />
      {isNewRoute && <Route exact path={`${match.url}/new`} component={PageCallNew} />}
      <Route exact path={`${match.url}/:id`} component={PageCallAdapter} />
    </Switch>
  </AuthModuleInit>
);

export default connect(state => ({ isNewRoute: isTelephonyAccess(state) }))(PhoneRouter);
