import React from 'react';
import PropTypes from 'prop-types';
import DropdownMenu from 'lego/components/DropdownMenu';
import StatusIcon from './StatusIcon';
import configStatus from './config';
import propTypes from '../../propTypes';
import css from './Status.modules.scss';

const StatusItem = ({ status }) => {
  const config = configStatus.TRANSLATE[status];

  if (!config) {
    return null;
  }

  const { text } = config;

  return (
    <span>
      <StatusIcon status={status} />&nbsp;
      {text}
    </span>
  );
};

StatusItem.propTypes = {
  status: propTypes.status.isRequired,
};

const Status = props => {
  const { status, change } = props;
  if (!status) {
    return null;
  }

  const config = configStatus.CHANGE_STATUS_RULES[status];

  const items =
    config &&
    config.map(key => ({
      text: <StatusItem status={key} />,
      val: key,
    }));

  return (
    <DropdownMenu
      size="s"
      text={<StatusItem status={status} />}
      onClick={(e, value) => change(value)}
      disabled={!config}
      className={css.Status}
      items={items}
    />
  );
};

Status.propTypes = {
  status: propTypes.status,
  change: PropTypes.func.isRequired,
};

Status.defaultProps = {
  status: undefined,
};

export default Status;
