import React from 'react';
import Icon from 'components/Icons/Icon';
import configStatus from './config';

const StatusIcon = ({ status, title, config }) => {
  const statusConfig = config[status];

  if (!statusConfig) {
    return null;
  }

  const { color, icon, text } = statusConfig;

  return <Icon {...icon} style={{ color }} title={title && text} />;
};

StatusIcon.defaultProps = {
  config: configStatus.TRANSLATE,
};

StatusIcon.CONFIG = configStatus;

export default StatusIcon;
