import Icon from 'components/Icons/Icon';
import { MANAGER_STATUS } from '../../constants';

const TRANSLATE = {
  [MANAGER_STATUS.AVAILABLE]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'check_circle',
    },
    text: 'Доступен',
    color: 'green',
  },
  [MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'check_circle',
    },
    text: 'Доступен (Исходящие)',
    color: '#0076d1',
  },
  [MANAGER_STATUS.WORKLOAD]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'phone_in_talk',
    },
    text: 'Звонок',
    color: 'red',
  },
  [MANAGER_STATUS.ACW]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'phone_locked',
    },
    text: 'Постобработка звонка',
    color: 'orange',
  },
  [MANAGER_STATUS.HOLD]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'phone_paused',
    },
    text: 'Удержание',
    color: 'orange',
  },
  [MANAGER_STATUS.SIDEWORK]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'work',
    },
    text: 'Другие задачи',
    color: 'orange',
  },
  [MANAGER_STATUS.LUNCH]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'free_breakfast',
    },
    text: 'Обед',
    color: 'orange',
  },
  [MANAGER_STATUS.SHORTBREAK]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'access_time',
    },
    text: 'Перерыв',
    color: 'orange',
  },
  [MANAGER_STATUS.MEETING]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'group',
    },
    text: 'Встреча',
    color: 'orange',
  },
  [MANAGER_STATUS.FORCED_PAUSE]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'pause',
    },
    text: 'Пауза',
    color: 'grey',
  },
  [MANAGER_STATUS.DISCONNECTED]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'block',
    },
    text: 'Оффлайн',
    color: 'grey',
  },
  [MANAGER_STATUS.UNKNOWN]: {
    icon: {
      pack: Icon.PACKS.MATERIAL,
      icon: 'help',
    },
    text: 'Неопределен',
    color: 'grey',
  },
};

export default {
  TRANSLATE,
  MANAGER_STATUS: {
    [MANAGER_STATUS.AVAILABLE]: TRANSLATE[MANAGER_STATUS.AVAILABLE],
    [MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY]: {
      ...TRANSLATE[MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY],
      color: 'red',
    },
    [MANAGER_STATUS.WORKLOAD]: {
      ...TRANSLATE[MANAGER_STATUS.WORKLOAD],
      color: 'red',
    },
    [MANAGER_STATUS.ACW]: {
      ...TRANSLATE[MANAGER_STATUS.ACW],
      color: 'red',
    },
    [MANAGER_STATUS.HOLD]: {
      ...TRANSLATE[MANAGER_STATUS.HOLD],
      color: 'red',
    },
    [MANAGER_STATUS.SIDEWORK]: {
      ...TRANSLATE[MANAGER_STATUS.SIDEWORK],
      color: 'red',
    },
    [MANAGER_STATUS.LUNCH]: {
      ...TRANSLATE[MANAGER_STATUS.LUNCH],
      color: 'red',
    },
    [MANAGER_STATUS.SHORTBREAK]: {
      ...TRANSLATE[MANAGER_STATUS.SHORTBREAK],
      color: 'red',
    },
    [MANAGER_STATUS.MEETING]: {
      ...TRANSLATE[MANAGER_STATUS.MEETING],
      color: 'red',
    },
    [MANAGER_STATUS.FORCED_PAUSE]: {
      ...TRANSLATE[MANAGER_STATUS.FORCED_PAUSE],
      color: 'red',
    },
    [MANAGER_STATUS.DISCONNECTED]: {
      ...TRANSLATE[MANAGER_STATUS.DISCONNECTED],
      color: 'red',
    },
    [MANAGER_STATUS.UNKNOWN]: TRANSLATE[MANAGER_STATUS.UNKNOWN],
  },
  CHANGE_STATUS_RULES: {
    [MANAGER_STATUS.AVAILABLE]: [
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.WORKLOAD]: null,
    [MANAGER_STATUS.ACW]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.SIDEWORK]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.LUNCH]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.SHORTBREAK]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.MEETING,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.MEETING]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.DISCONNECTED,
    ],
    [MANAGER_STATUS.FORCED_PAUSE]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
    ],
    [MANAGER_STATUS.DISCONNECTED]: [
      MANAGER_STATUS.AVAILABLE,
      MANAGER_STATUS.AVAILABLE_OUTBOUND_ONLY,
      MANAGER_STATUS.SIDEWORK,
      MANAGER_STATUS.LUNCH,
      MANAGER_STATUS.SHORTBREAK,
      MANAGER_STATUS.MEETING,
    ],
  },
};
