import get from 'lodash/get';
import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';
import { FRONTEND_MANAGER_STATUS } from 'modules/phone/constants';

const ACTION_TYPES = {
  SET_STATUS: 'SET_STATUS',
};

let timer = null;

const setStatus = (status) => {
  clearTimeout(timer);
  timer = null;
  return { type: ACTION_TYPES.SET_STATUS, payload: status };
};

const setDefaultStatus = () => setStatus(FRONTEND_MANAGER_STATUS.DEFAULT);

const outboundCall = () => (dispatch) => {
  dispatch(setStatus(FRONTEND_MANAGER_STATUS.OUTBOUND_CALL));
  timer = setTimeout(() => {
    dispatch(setDefaultStatus());
  }, 5000);
};

const behaviors = {
  [ACTION_TYPES.SET_STATUS](state, { payload }) {
    return payload;
  },
};

export default {
  REDUCER_KEY: 'frontendStatus',
  ACTION_TYPES,
  FRONTEND_MANAGER_STATUS,
  reducer: reducerFactoryRaw(ACTION_TYPES, behaviors, FRONTEND_MANAGER_STATUS.DEFAULT),
  actions: {
    setStatus,
    setDefaultStatus,
    outboundCall,
  },
  selectors: {
    status: state => get(state, 'phone.frontendStatus'),
  },
};
