import { apiCall } from 'api/common';
import get from 'lodash/get';
import { getCallState } from './selectors';
import { MOUNT, DESTROY, UPDATE } from './actionTypes';

export const mount = index => ({ type: MOUNT, meta: { name: index } });
export const destroy = index => ({ type: DESTROY, meta: { name: index } });
export const update = (data, index) => ({ type: UPDATE, data, meta: { name: index } });

export const fetch = callId => (dispatch, getState) => {
  dispatch(mount(callId));
  return apiCall('/view/call', { callId }).then((data) => {
    if (get(getCallState(getState(), callId), 'mounted')) {
      dispatch(update(data, callId));
    }
  });
};
