import arrayReducerFactoryRaw from 'utils/reducer/arrayReducerFactoryRaw';
import * as aTypes from './actionTypes';

const INIT_STATE = {
  mounted: 0,
};

const behaviors = {
  [aTypes.UPDATE](state, action) {
    return {
      ...state,
      data: action.data,
    };
  },
  [aTypes.MOUNT](state) {
    return { ...state, mounted: state.mounted + 1 };
  },
  [aTypes.DESTROY](state) {
    const newMounted = state.mounted - 1;
    if (!newMounted) {
      return undefined;
    }
    return { mounted: newMounted };
  },
};

export default arrayReducerFactoryRaw(aTypes, behaviors, INIT_STATE);
