import { BACKEND_CMD } from 'modules/phone/constants';
import createWebsocketReducer from '../../utils/createWebsocketReducer';

const INIT_STATE = {
  status: {},
};

const behaviors = {
  [BACKEND_CMD.GET_AGENT_STATE](state, action) {
    const usersCount = Object.keys(action.data).length;

    // телефония использует этот тип сообщений для двух случаев: регулярное обноволение статуса
    // текущего менеджера и получения статусов для списка менеджеров
    // различить эти случаи не возможно
    // поэтому делаем так для списка менеджеров
    if (usersCount > 1) {
      return {
        ...state,
        status: action.data,
      };
    }

    // если только один менеджер то мерджим
    return {
      ...state,
      status: {
        ...state.status,
        ...action.data,
      },
    };
  },
};

export default createWebsocketReducer(behaviors, INIT_STATE);
