import get from 'lodash/get';
import {
  NEW_CALL_RECEIVE,
  DESTROY,
  SET_ACCOUNT,
  SET_CALL_DATA,
  SET_CALL_INFO,
  SET_CALL_MAIL,
  SET_ALREADY_SEND,
  SET_SEND,
  SET_SAVE,
  SET_ADDRESSEE_DETAILS,
  SET_TIP,
} from '../actionTypes/newCall';

const frontendBehaviors = {
  [SET_ALREADY_SEND](state) {
    return {
      ...state,
      isAlreadySend: true,
    };
  },
  [SET_SEND](state) {
    return {
      ...state,
      isSend: true,
    };
  },
  [SET_SAVE](state) {
    return {
      ...state,
      isSave: true,
    };
  },
  [SET_CALL_DATA](state, { payload }) {
    return {
      ...state,
      callData: payload,
    };
  },
  [SET_CALL_INFO](state, { payload }) {
    return {
      ...state,
      callInfo: payload,
    };
  },
  [SET_ADDRESSEE_DETAILS](state, { payload }) {
    return {
      ...state,
      callInfo: {
        ...state.callInfo,
        callerName: payload.callerName,
        inn: payload.inn,
        contractNum: payload.contractNum,
      },
      mail: { ...state.mail, to: payload.mailTo },
    };
  },
  [SET_TIP](state, { payload }) {
    if (payload) {
      const tipPermission = get(payload, 'uiPermissions.call.tip');

      // hack for CRM-8050
      return {
        ...state,
        tip: payload.tip,
        uiPermissions: {
          ...state.uiPermissions,
          call: {
            ...Object(state.uiPermissions).call,
            tip: tipPermission,
          },
        },
      };
    }

    return state;
  },
  [SET_CALL_MAIL](state, { payload }) {
    return {
      ...state,
      mail: payload,
    };
  },
  [SET_ACCOUNT](state, { payload }) {
    return {
      ...state,
      account: payload,
    };
  },
  [NEW_CALL_RECEIVE](state, { payload = {} }) {
    /*
     * https://st.yandex-team.ru/CRM-6826#1527604881000
     * похоже на баг в redux-form
     * для обхода: значениям, которые могут меняться, присваиваем пустую строку
     * */
    return {
      ...state,
      isLoad: true,
      ...payload,
      mail: {
        to: '',
        ...payload.mail,
      },
      callInfo: {
        callerName: '',
        opportunities: [],
        ...payload.callInfo,
      },
    };
  },
  [DESTROY]() {
    return null;
  },
};

export default (state = null, action) => {
  const { type } = action;
  const frontendBehavior = frontendBehaviors[type];
  if (frontendBehavior) {
    return frontendBehavior(state || { callInfo: {} }, action);
  }

  return state;
};
