import { LOAD_SAVE_CALL_RECEIVE } from '../actionTypes/savedCall';

const frontendBehaviors = {
  [LOAD_SAVE_CALL_RECEIVE](state, { payload }) {
    return payload;
  },
};

export default (state = null, action) => {
  const { type } = action;
  const frontendBehavior = frontendBehaviors[type];
  if (frontendBehavior) {
    return frontendBehavior(state || {}, action);
  }

  return state;
};
