import { CLOSE } from 'middlewares/websocket';
import { BACKEND_CMD, NAME, MANAGER_STATUS } from 'modules/phone/constants';
import createWebsocketReducer from '../../utils/createWebsocketReducer';

const INIT_STATE = {
  isConnectionReady: false,
  settings: {},
};

const interfaceNormalize = data => {
  if (Array.isArray(data)) {
    const result = {
      value: undefined,
      map: {},
      list: [],
    };
    data.forEach(item => {
      if (item.default) {
        result.value = item.interface;
      }

      result.map[item.interface] = item;
      result.list.push(item.interface);
    });
    return result;
  }

  return undefined;
};

const behaviors = {
  [CLOSE](state, action) {
    if (
      action &&
      action.meta &&
      action.meta.name === NAME &&
      action.data &&
      action.data.code === 1000
    ) {
      return {
        ...state,
        status: MANAGER_STATUS.UNKNOWN,
        isConnectionReady: true,
        reason: action.data.reason,
      };
    }

    return state;
  },
  [BACKEND_CMD.AGENT_CURRENT_STATE](state, action) {
    return {
      ...state,
      status: action.data.state,
      activeCall: action.data.active_call,
      isConnectionReady: true,
    };
  },
  [BACKEND_CMD.UPDATE_AGENT_STATE](state, action) {
    return {
      ...state,
      status: action.data.state,
    };
  },
  [BACKEND_CMD.CALL_INFO](state, action) {
    return {
      ...state,
      activeCall: action.data,
    };
  },
  [BACKEND_CMD.CALL_END](state) {
    return {
      ...state,
      activeCall: undefined,
    };
  },
  [BACKEND_CMD.GET_DEFAULT_INTERFACE_NAME](state, action) {
    return {
      ...state,
      settings: {
        ...state.settings,
        interface: interfaceNormalize(action.data),
      },
    };
  },
};

behaviors[BACKEND_CMD.SET_DEFAULT_INTERFACE_NAME] =
  behaviors[BACKEND_CMD.GET_DEFAULT_INTERFACE_NAME];

export default createWebsocketReducer(behaviors, INIT_STATE);
