import get from 'lodash/get';
import Access from 'utils/Access';
import { MANAGER_STATUS } from '../constants';

export const getAccount = (state) => get(state, 'phone.newCall.account');
export const getAccountId = (state) => get(state, 'phone.newCall.account.id');
export const getNewCall = (state) => get(state, 'phone.newCall');
export const getNewCallId = (state) => get(state, 'phone.newCall.callInfo.id');
export const getIsCreateAccountForNewCall = (state) =>
  Access.isEdit(get(state, 'phone.newCall.uiPermissions.call.createAccount', 0));
export const canOpenPinForm = (state) =>
  Access.isEdit(get(state, 'phone.newCall.uiPermissions.call.enterPin', 0));
export const getIsLoadNewCall = (state) => get(state, 'phone.newCall.isLoad');
export const getIsSendNewCall = (state) => get(state, 'phone.newCall.isSend');
export const getIsSaveNewCall = (state) => get(state, 'phone.newCall.isSave');
export const getSaveCall = (state) => get(state, 'phone.saveCall');
export const getActiveCall = (state) => get(state, 'phone.status.activeCall');
export const getStatus = (state) => get(state, 'phone.status.status');
export const getReason = (state) => get(state, 'phone.status.reason');
export const isTelephonyAccess = (state) =>
  get(state, 'phone.status.status') !== MANAGER_STATUS.UNKNOWN;
export const getIsConnectionReady = (state) => get(state, 'phone.status.isConnectionReady');
export const getInterface = (state) => get(state, 'phone.status.settings.interface');
