import { MESSAGE } from 'middlewares/websocket';

export default (behaviors, initState = {}) => (state = null, action) => {
  const { type } = action;
  if (type === MESSAGE) {
    const { data } = action;
    const cmd = data && data.cmd;
    const behavior = behaviors[cmd];
    if (behavior) {
      return behavior(state || initState, data);
    }
  } else {
    const behavior = behaviors[type];
    if (behavior) {
      return behavior(state || initState, action);
    }
  }

  return state;
};
