export default (data) => {
  if (!(data && Array.isArray(data.items))) {
    return data;
  }

  const items = data.items.map(item => ({
    ...item,
    callId: item.id,
    id: item.id || item.sessionId + item.phaseId,
  }));

  return {
    ...data,
    items,
  };
};
