import { jsonApiCall } from 'entry/api/common';
import { PinConfig } from 'types/PinConfig';
import { PinFormModal } from './PinFormModal';
import { FormValues, PinCheckRequest } from './PinForm.types';

export const createPinFormSubmit = (pinConfig: PinConfig) => (
  values: FormValues,
): Promise<unknown> => {
  const { pin } = values;

  return jsonApiCall<PinCheckRequest>({
    url: '/view/pin/check',
    data: {
      pin,
      pinSource: pinConfig.pinSource,
      pinTarget: pinConfig.pinTarget,
    },
  });
};

export const showPinModal = (pinConfig: PinConfig) => {
  PinFormModal.open({
    onSubmit: createPinFormSubmit(pinConfig),
  });
};

export const needAutoShowPin = (pinConfig: PinConfig): Promise<boolean> => {
  return jsonApiCall({
    url: '/view/pin/show',
    data: {
      accountId: pinConfig.accountId,
      pinSource: pinConfig.pinSource,
    },
  }).then((data) => {
    return data && data.autoShowPin;
  });
};

export const showPinModalIfNeeded = (pinConfig: PinConfig) => {
  return needAutoShowPin(pinConfig).then((needToShow) => {
    if (needToShow) {
      return showPinModal(pinConfig);
    }
  });
};
