import * as React from 'react';
import { errorMessage, FieldRow, Form, FormProps, FormText } from 'components/FinalForm';
import { FormValues, PinFormProps } from './PinForm.types';

const validate = (values: FormValues) => {
  const error: { [key: string]: string } = {};

  if (!values.pin) {
    error.pin = errorMessage.required;
  }

  return error;
};

const PinForm: React.FC<PinFormProps> = ({ onSubmit, onSubmitSuccess, onCancel }) => {
  const formProps: FormProps<FormValues> = {
    onSubmit,
    onSubmitSuccess,
    onCancel,
    validate,

    title: 'Ввод пина аккаунта',
    successButtonText: 'Отправить',
    cancelButtonText: 'Отмена',
  };

  return (
    <Form {...formProps}>
      <FormText>Введите пин аккаунта, чтобы получить доступ к дополнительным сервисам</FormText>
      <FieldRow component="TextInput" name="pin" label="Пин" />
    </Form>
  );
};

export default PinForm;
