import { FC, useEffect } from 'react';
import { ETypeString } from 'types/entities';
import { webphoneIncomingCallService } from 'modules/webphone/services/WebphoneIncomingCallService';
import { showPinModalIfNeeded } from '../PinForm.service';

export const PinModalObserver: FC = () => {
  useEffect(() => {
    let subscription = webphoneIncomingCallService.onCallAccept((data) => {
      showPinModalIfNeeded({
        accountId: data.accountId,
        pinSource: data.callId ? { eid: data.callId, etype: ETypeString.YcCall } : undefined,
        pinTarget: { eid: data.issueId, etype: ETypeString.Issue },
      });
    });

    if (window.pinConfig) {
      showPinModalIfNeeded(window.pinConfig);
    }

    return () => {
      subscription.unsubscribe();
    };
  }, []);

  return null;
};
