import { push } from 'modules/notificationsUI';
import { connect } from 'react-redux';
import get from 'lodash/get';
import TreeViewDialog from 'dialogs/TreeView';
import { NAME } from '../../constants';
import * as actions from '../../redux/actions';
import * as aTypes from '../../redux/actionTypes';
import { VIEW_NAME } from '../Notification';
import { TreeFormItem } from '../../types';
import Form from './Form';

export const mapState = (state) => ({
  dialog: state[NAME],
});

export const mapDispatch = (dispatch, props) => ({
  onSelectCategoryClick: (selectedId) =>
    TreeViewDialog.actions
      .loadData(
        null,
        (props.data.context || {}).action || 'request',
        undefined,
        get(props, 'data.data.issueId'),
      )(dispatch)
      .then(() => {
        if (selectedId) {
          dispatch(TreeViewDialog.actions.setSelected({ id: selectedId }));
        }
        dispatch(TreeViewDialog.actions.toggle(true));
      }),

  onChangeCategory: (itemId: number, item: TreeFormItem) => {
    if (item) {
      dispatch(actions.formDataReceive({ category: { id: item.id, name: item.fullPath } }));
    }
  },

  onSubmit: (args) => {
    return actions
      .save(args)
      .then((data) => {
        dispatch(actions.setStatus(true, data));
        if (props.onOK) {
          props.onOK(args);
        }

        dispatch(
          push({
            text: `Создан новый тикет: ${data.id}`,
            level: 'success',
            view: VIEW_NAME,
            extra: data,
          }),
        );

        if (typeof props.onSubmitSuccess === 'function') {
          props.onSubmitSuccess(data);
        }
      })
      .catch((error) => {
        dispatch({ type: aTypes.SAVE_FAILED });

        throw error;
      });
  },

  onCancel: () => {
    if (props.onCancel) {
      props.onCancel();
    }
  },

  onPriorityChange: (value) => dispatch(actions.changePriority(Number(value))),

  onUpdateForm: (args) =>
    actions
      .form({
        ...args,
        data: {
          ...(args || {}).data,
          mailId: get(props, 'data.data.mailId'),
        },
      })
      .then((data) => {
        dispatch(actions.formDataReceive(data));
      })
      .catch((error) => {
        dispatch(actions.formDataFail());

        throw error;
      }),

  setClient: (data) => dispatch(actions.setClient(data)),

  onFilesAdd: (args) => dispatch(actions.fileAdd(args)),
  onFileRemove: (args) => dispatch(actions.fileRemove(args)),
  reset: () => dispatch(actions.reset()),
  load: (data) => dispatch(actions.load(data)),
});

export default connect(mapState, mapDispatch)(Form);
