import { ModalForm, ModalFormProps } from 'lego/utils/modalForm';
import store from 'store';
import Form from './Form';
import { load } from '../redux/actions';
import { FormProps } from '../types';

const modal = new ModalForm<FormProps & ModalFormProps>({
  key: 'CREATE_TICKET',
  formComponent: Form,
  modalProps: {
    size: 'mid',
    "data-testid": "modal-create-request-ticket"
  },
  onLoad: (props) => {
    // eslint-disable-next-line
    return store.dispatch(load(props.data) as any);
  },
});

export default modal;
