import { connect } from 'react-redux';
import { InjectView as Inject, NotificationBase as Base } from 'modules/notificationsUI';
import { history } from 'appHistory';
import getIssueLink from '../utils/getIssueLink';

const mapDispatch = (dispatch, props) => {
  if (props.extra && props.extra.id) {
    return {
      actions: [
        {
          children: 'Открыть',
          onClick: () => history.push(getIssueLink(props.extra.id)),
        },
      ],
    };
  }

  return null;
};

const Notification = connect(null, mapDispatch)(Base);

export const VIEW_NAME = 'NEW_ISSUE_SECOND_LINE';

Inject.addView(VIEW_NAME, Notification);

export default Notification;
