import React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import searchToData from '../../utils/searchToData';
import Form from '../Form';
import css from './Page.module.css';
import { IssueCreateFormRequest } from '../../types';

interface PageProps extends RouteComponentProps {
  load: (data: IssueCreateFormRequest) => void;
  reset: () => void;
}

interface PageState {
  data?: IssueCreateFormRequest;
}

export default class Page extends React.Component<PageProps, PageState> {
  public constructor(props) {
    super(props);

    this.state = {};
  }

  public componentDidMount() {
    this.load();
  }

  public componentDidUpdate(prevProps: PageProps) {
    if (this.props.location.search !== prevProps.location.search) {
      this.update();
    }
  }

  private update = () => {
    this.props.reset();
    this.load();
  };

  private load() {
    const data = searchToData(this.props.location.search);

    this.props.load(data);
    this.setState({ data });
  }

  public render() {
    const { data } = this.state;

    return (
      <div className={css.wrap}>
        <div className={css.form}>
          <Form data={data} />
        </div>
      </div>
    );
  }
}
