import { jsonApiCall } from 'api/common';
import api from 'api';
import TreeViewDialog from 'dialogs/TreeView';
import * as t from './actionTypes';
import { IssueCreateFormRequest, IssueCreateFormResponse, PostFormRequest } from '../types';

export const formDataReceive = (data) => ({ type: t.FORM_DATA_RECEIVE, data });
export const formDataFail = () => ({ type: t.FORM_DATA_FAIL });

export const reset = () => (dispatch) => {
  dispatch(TreeViewDialog.actions.reset());
  return dispatch({ type: t.RESET });
};

export const setStatus = (status, data) => ({ type: t.SET_STATUS, status, data });

export const setClient = (data) => ({ type: t.SET_CLIENT, data });

export const setFiles = (data) => ({ type: t.SET_FILES, data });
export const setData = (data) => ({ type: t.SET_DATA, data });

const loadData = (data: IssueCreateFormRequest) =>
  jsonApiCall({
    url: '/issues/createticketform',
    data,
  });

export const load = (data: IssueCreateFormRequest) => (dispatch) =>
  loadData(data).then((response) => {
    dispatch(setData(response));
    return response;
  });

export const save = (data: PostFormRequest) => jsonApiCall({ url: '/issues/createticket', data });
export const form = (data: PostFormRequest) =>
  loadData({
    data: {
      byEObject: data.data.byEObject,
      mailId: data.data.mailId,
      parentId: data.data.parentId,
      categoryId: data.data.categoryId,
      accountId: data.data.accountId,
      email: data.data.email,
      doNotGenerateId: true,
    },
    context: data.context,
  }).then((response: IssueCreateFormResponse) => {
    return { form: response.form };
  });

export const fileAdd = (args) => (dispatch) =>
  api.actions.file.add(args).then((data) => {
    dispatch(setFiles(data));
  });

export const fileRemove = (args) => (dispatch) =>
  api.actions.file.remove(args).then((data) => {
    dispatch(setFiles(data));
  });

export const changePriority = (value) => ({ type: t.CHANGE_PRIORITY, value });
