import * as t from './actionTypes';

const initState = {
  data: {},
  status: false,
  error: false,
  isFormHide: false,
  priority: 8,
};

export default (state = initState, action) => {
  let newState;
  switch (action.type) {
    case t.FORM_DATA_RECEIVE:
      return {
        ...state,
        data: { ...state.data, ...action.data },
        isFormHide: false,
      };
    case t.FORM_DATA_FAIL:
      return {
        ...state,
        data: { ...state.data },
        isFormHide: true,
      };
    case t.RESET:
      return initState;
    case t.SET_DATA:
      return { ...state, data: action.data };
    case t.SET_FILES:
      newState = { ...state };
      newState.data.files = action.data.files;
      newState.data.containerId = action.data.containerId;
      return newState;
    case t.SET_CLIENT:
      newState = { ...state };
      newState.data.account = {};
      newState.data.account.info = action.data;
      return newState;

    case t.SAVE_FAILED:
      return { ...state, error: true };
    case t.SET_STATUS:
      return { ...state, status: action.status, receiveData: action.data };
    case t.CHANGE_PRIORITY:
      return { ...state, priority: action.value };
    default:
      return state;
  }
};
