import objToKeyObj from 'utils/objToKeyObj';

export enum AppModule {
  None = 0,
  Issue = 1,
  Ticket = 2,
  Account = 3,
  PersonalMail = 4,
  Telephony = 5,
  Chat = 6,
}

export const AppModuleString = objToKeyObj(AppModule);

export type AppModuleType = keyof typeof AppModuleString;

export interface IssueCreateFormRequestArg {
  accountId?: number;
  categoryId?: number;
  campaignId?: string;
  mailId?: number;
  issueId?: number;
  parentId?: number;
  email?: string;
  doNotGenerateId?: boolean;
  byEObject?: { eid: number; etype: string };
  byChat?: { chatId: string; orgId: string };
}

interface Context {
  module: AppModuleType;
  action?: string;
}

export interface IssueCreateFormRequest {
  data: IssueCreateFormRequestArg;
  context?: Context;
}

interface Form {
  extFormId: number;
  formText: string;
  id: number;
}

export interface IssueCreateFormResponse {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  account?: any;
  category?: { id: number; name: string; fullPath?: string };
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  files?: any;
  containerId?: number;
  form?: Form;
  issueId?: number;
  initializeFormFields?: { [key: string]: string };
}

export interface FormProps {
  data: IssueCreateFormRequest;
  title?: string;
}

export interface PostFormRequestArg {
  byEObject?: { eid: number; etype: string };
  issueId: number;
  categoryId: number;
  accountId: number;
  parentId?: number;
  formId: number;
  containerId?: number;
  priorityId?: number;
  mailId?: number;
  email?: string;
}

export interface PostFormRequest {
  data: PostFormRequestArg;
  context?: Context;
}

export interface PostFormResponse {
  id: number;
  category: { id: number; name: string };
  state: { id: number; name: string };
}

export interface ReduxState {
  data: IssueCreateFormResponse;
  receiveData?: PostFormResponse;
  status: boolean;
  error: boolean;
  isFormHide: boolean;
  priority: number;
}

export interface TreeFormItem {
  id: number;
  fullPath: string;
}
