import { IssueCreateFormRequest } from '../types';

const simpleKeys = ['accountId', 'categoryId', 'campaignId', 'mailId', 'issueId', 'email'];

export default (props: IssueCreateFormRequest): string => {
  const { data, context } = props;
  const params = new URLSearchParams();

  simpleKeys.forEach((key) => {
    const value = data[key];
    if (value) {
      params.set(key, value);
    }
  });

  if (data.byEObject) {
    params.set('eid', String(data.byEObject.eid));
    params.set('etype', String(data.byEObject.etype));
  }

  if (data.byChat) {
    params.set('chatId', data.byChat.chatId);
    params.set('orgId', data.byChat.orgId);
  }

  if (context && context.module) {
    params.set('module', context.module);
  }

  if (context && context.action) {
    params.set('action', context.action);
  }

  return params.toString();
};
