import { IssueCreateFormRequest, IssueCreateFormRequestArg, AppModuleType } from '../types';

const idKeys = ['accountId', 'categoryId', 'campaignId', 'mailId', 'issueId'];

export default (str: string): IssueCreateFormRequest => {
  const params = new URLSearchParams(str);

  const data: IssueCreateFormRequestArg = idKeys
    .map((key) => [key, Number.parseInt(String(params.get(key)), 10)] as [string, number])
    .filter((item) => !Number.isNaN(item[1]))
    .reduce((ac, [key, value]) => {
      // eslint-disable-next-line no-param-reassign
      ac[key] = value;

      return ac;
    }, {});

  const email = params.get('email');
  if (email) {
    data.email = email;
  }

  const eid = Number.parseInt(String(params.get('eid')), 10);
  const etype = params.get('etype');

  if (!Number.isNaN(eid) && etype) {
    data.byEObject = { eid, etype };
  }

  const chatId = params.get('chatId');
  const orgId = params.get('orgId');

  if (chatId && orgId) {
    data.byChat = { chatId, orgId };
  }

  const result: IssueCreateFormRequest = { data };

  const module = params.get('module') as AppModuleType;
  const action = params.get('action') as string | undefined;
  if (module) {
    result.context = { module, action };
  }

  return result;
};
