import { Resizable } from '@crm/components/dist/Resizable';
import { connect } from 'react-redux';
import redux from '../../redux';

const mapState = (state, props) => ({
  size: props.size || redux.selectors.getSizeByName(state, props.name),
});

const mapDispatch = (dispatch, props) => ({
  onSizeChange: (size) => dispatch(redux.actions.setSize(props.name, size)),
});

export default connect(mapState, mapDispatch)(Resizable);
