import { ResizeModel } from 'services/DBProvider/Models';
import { getBindInstance } from 'services/DBProvider/Models/Models.utils';
import { actions } from 'entry/modules/initial/UiSettings/actions';

const resizeModel = getBindInstance(ResizeModel);

export const setSize = (name, size) => (dispatch) => {
  resizeModel.then((model) =>
    model.update({
      panelId: name,
      size,
    }),
  );

  return dispatch(
    actions.setSize({
      size,
      meta: { name },
    }),
  );
};
