import { createSlice } from '@reduxjs/toolkit';

export const resizeUISlice = createSlice({
  name: 'resize',
  reducers: {
    setSize: (state, { payload }) => {
      const { size, meta } = payload;
      return {
        ...state,
        resize: {
          ...state.resize,
          [meta.name]: {
            ...state.resize[meta.name],
            size,
          },
        },
      };
    },
  },
});

export default resizeUISlice.reducer;
