import { getFormValues } from 'redux-form';
import { jsonApiCall } from 'api/common';
import { REVIEW } from 'constants/modules-name.js';
import backendDataAdapter from 'containers/TreeSelect/backendDataAdapter';
import backendTypes from 'constants/backendTypesRaw';
import api from 'api';
import { REVIEW_FILTER } from './constants';

export const LIST_REQUEST = `${REVIEW}LIST_REQUEST`;
export const LIST_RECIEVE = `${REVIEW}LIST_RECIEVE`;
export const LIST_FAIL = `${REVIEW}LIST_FAIL`;

const transformCallData = (data) => {
  if (
    data &&
    Array.isArray(data.communicationTypes) &&
    data.communicationTypes.includes(backendTypes.TYPES.CALL)
  ) {
    const index = data.communicationTypes.indexOf(backendTypes.TYPES.CALL);
    const communicationTypes = [...data.communicationTypes];
    communicationTypes.splice(index, 1, backendTypes.TYPES.YC_CALL, backendTypes.TYPES.SP_CALL);
    return { ...data, communicationTypes };
  }
  return data;
};

export const getList = (args) => (dispatch, getState) => {
  // получить данные формы через getState
  return dispatch({
    type: 'PROMISE',
    promise: api.view.support.review.report({
      ...args,
      ...backendDataAdapter(transformCallData(getFormValues(REVIEW_FILTER)(getState()))),
    }),
    actions: [LIST_REQUEST, LIST_RECIEVE, LIST_FAIL],
  });
};

export const ITEM_REQUEST = `${REVIEW}ITEM_REQUEST`;
export const ITEM_RECIEVE = `${REVIEW}ITEM_RECIEVE`;
export const ITEM_FAIL = `${REVIEW}ITEM_FAIL`;

export const getItem = (args) => (dispatch) =>
  dispatch({
    type: 'PROMISE',
    promise: api.view.support.review.item(args),
    actions: [ITEM_REQUEST, ITEM_RECIEVE, ITEM_FAIL],
  });

export const ITEM_RESET = `${REVIEW}ITEM_RESET`;
export const resetItem = { type: ITEM_RESET };

export const SAVE_REQUEST = `${REVIEW}SAVE_REQUEST`;
export const SAVE_RECIEVE = `${REVIEW}SAVE_RECIEVE`;
export const SAVE_FAIL = `${REVIEW}SAVE_FAIL`;

export const saveItem = (args) => (dispatch) =>
  dispatch({
    type: 'PROMISE',
    promise: api.actions.support.review.item.save(args),
    actions: [SAVE_REQUEST, SAVE_RECIEVE, SAVE_FAIL],
  });

export const saveReviewer = (args) => (dispatch) =>
  dispatch({
    type: 'PROMISE',
    promise: jsonApiCall({
      url: '/actions/support/review/save',
      data: args,
    }),
    actions: [SAVE_REQUEST, SAVE_RECIEVE, SAVE_FAIL],
  });

export const ADD_REQUEST = `${REVIEW}ADD_REQUEST`;
export const ADD_RECIEVE = `${REVIEW}ADD_RECIEVE`;
export const ADD_FAIL = `${REVIEW}ADD_FAIL`;

export const addItem = (args) => (dispatch) =>
  dispatch({
    type: 'PROMISE',
    promise: api.actions.support.review.item.addNew({ reviewId: args.after }),
    actions: [ADD_REQUEST, ADD_RECIEVE, ADD_FAIL],
  });

export const SET_PANEL = `${REVIEW}SET_PANEL`;
export const setPanel = (name) => ({ type: SET_PANEL, name });

export const INSERT_ITEM = `${REVIEW}INSERT_ITEM`;
/**
 * @param {Object} args
 * @param {Number} args.after - item id for insert after it
 * @param {Object} args.item - item for insert
 * */
export const insertItem = (args) => ({ type: INSERT_ITEM, ...args });

export const UPDATE_ITEM = `${REVIEW}UPDATE_ITEM`;
export const updateItem = (args) => ({ type: UPDATE_ITEM, ...args });
