import React from 'react';
import FormBuilder from '../FormBuilder';
import css from './Calculator.modules.scss';

class Calculator extends React.Component {
  static defaultProps = {
    score: 0,
  };

  constructor(props) {
    super(props);

    const { calculate } = props.meta;
    this.state = { score: props.score };
    this.metaCalculate = Function('values', calculate);
  }

  getData() {
    return this.form.getData();
  }

  isValid() {
    return this.form.isValid();
  }

  value() {
    return this.state.score;
  }

  reset() {
    this.form.reset();
  }

  handleChange = values => {
    this.setState({ score: this.metaCalculate(values) }, this.props.onChange);
  };

  render() {
    const { meta, data, disabled } = this.props;

    return (
      <div>
        <FormBuilder
          ref={node => {
            this.form = node;
          }}
          onChange={this.handleChange}
          meta={meta}
          initialValues={data}
          disabled={disabled}
        />
        <div className={css.result}>
          <span className={css.mark}>
            Оценка: <span className={css.points}>{this.state.score}</span>
          </span>
          <span className={css.maxPoints}>/{this.props.meta.maxScore}</span>
        </div>
      </div>
    );
  }
}

export default Calculator;
